//==========================================================================;
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright (c) 1992 - 1998  Microsoft Corporation.  All Rights Reserved.
//
//--------------------------------------------------------------------------;
//
// iaudiotp.h
//

#ifndef __IAUDIOTAP__
#define __IAUDIOTAP__

#ifdef __cplusplus
extern "C" {
#endif


// IAudioTap's GUID
// {7EB38D1A-8CFE-4cc2-930F-2802DF22D441}
DEFINE_GUID(IID_IAudioTap, 
0x7eb38d1a, 0x8cfe, 0x4cc2, 0x93, 0xf, 0x28, 0x2, 0xdf, 0x22, 0xd4, 0x41);


//
// IAudioTap
//
DECLARE_INTERFACE_(IAudioTap, IUnknown) {

    STDMETHOD(get_Callback)
        ( THIS_
          AudioTapCallback *pCallback //[out]
        ) PURE;

    STDMETHOD(put_Callback)
        ( THIS_
          AudioTapCallback pCallback  //[in]
        ) PURE;

    STDMETHOD(get_Context)
        ( THIS_
          void **pContext //[out]
        ) PURE;

    STDMETHOD(put_Context)
        ( THIS_
          void *pContext  //[in]
        ) PURE;

    STDMETHOD(put_Pass)
        ( THIS_
          BOOL Value  //[in]
        ) PURE;

    STDMETHOD(get_Pass)
        ( THIS_
          BOOL *Value  //[out]
        ) PURE;

    STDMETHOD(put_Force_24BPS)
        ( THIS_
          BOOL Value  //[in]
        ) PURE;

    STDMETHOD(get_Force_24BPS)
        ( THIS_
          BOOL *Value  //[out]
        ) PURE;

};

#ifdef __cplusplus
}
#endif

#endif // __IAUDIOTAP__
